﻿IF OBJECT_ID('V_SPED_EST_NF_SAI') IS NOT NULL
	BEGIN
			DROP VIEW V_SPED_EST_NF_SAI
	END

GO

SET QUOTED_IDENTIFIER ON

GO

CREATE VIEW V_SPED_EST_NF_SAI
WITH ENCRYPTION
AS
	SELECT
		V_EST_NF_SAI.CD_NF                                                                   AS CD_DOC
		,V_EST_NF_SAI.CD_FILIAL
		,1                                                                                   AS IND_OPER
		,0                                                                                   AS IND_EMIT
		,V_EST_NF_SAI.CD_CLI                                                                 AS CD_ORIG
		,'01'                                                                                AS COD_MOD
		,V_EST_NF_SAI.TP_SR_NFE
		,V_EST_NF_SAI.SERIE
		,V_EST_NF_SAI.NF_NF                                                                  AS NR_DOC
		,ISNULL(EST_NF_SAI_NFE.NR_AUTORIZADOR, '')                                           AS CHAVE_NFE
		,V_EST_NF_SAI.DT_EMI_NF
		,V_EST_NF_SAI.DT_EMI_NF                                                              AS DT_ENT_SAI
		,V_EST_NF_SAI.VLR_NF
		,V_EST_NF_SAI.CD_COND_PGTO                                                           AS IND_PAGTO
		,V_EST_NF_SAI.VLR_DESC_CORPO                                                         AS VLR_DESC
		,0                                                                                   AS VLR_ABAT
		,CASE WHEN V_EST_NF_SAI.FLAG_NF_PROD_TOTAL_BRUTO = 0 THEN V_EST_NF_SAI.VLR_TOT_PROD
		 ELSE V_EST_NF_SAI.VLR_TOT_PROD - V_EST_NF_SAI.VLR_DESC_CORPO
		 END                                                                                 AS VLR_MERC
		,1                                                                                   AS TP_FRETE
		,VLR_FRETE
		,V_EST_NF_SAI.VLR_OUTROS                                                             AS VLR_OUTROS
		,COALESCE(CAB.VLR_BASE_ICMS_PROD, V_EST_NF_SAI.VLR_BASE_ICMS)                        AS VLR_BASE_ICMS_CAB
		,COALESCE(CAB.VLR_ICMS_PROD, V_EST_NF_SAI.VLR_ICMS)                                  AS VLR_ICMS_CAB
		--,V_EST_NF_SAI.VLR_BASE_SUBS_CAB									                     AS VLR_BASE_ICMS_SUBS_CAB
		--,V_EST_NF_SAI.VLR_ICMS_SUBS_CAB														 AS VLR_ICMS_SUBS_CAB
		,COALESCE(CAB.VLR_BASE_SUBS_PROD, V_EST_NF_SAI.VLR_BASE_SUBS_CAB)                     AS VLR_BASE_ICMS_SUBS_CAB
		,COALESCE(CAB.VLR_ICMS_SUBS_PROD, V_EST_NF_SAI.VLR_ICMS_SUBS_CAB)                     AS VLR_ICMS_SUBS_CAB

		,V_EST_NF_SAI.VLR_IPI                                                                AS VLR_IPI_CAB
		,V_EST_NF_SAI.CGC_CPF
		,V_EST_NF_SAI.STS_NF
		,V_EST_NF_SAI.VLR_OUTROS                                                             AS VLR_SERV_NT
		,V_EST_NF_SAI.VLR_ISSQN                                                              AS VLR_ISSQN_CAB
		,V_EST_NF_SAI.VLR_ISENTAS
		,V_EST_NF_SAI.VLR_ISENTAS_IT
		,CD_TRANSP
		,QT_VOL
		,PESO_BRT
		,PES_LIQ                                                                             AS PESO_LIQ
		,ISNULL(RC_DEB_EST_NF_SAI.CD_EMP, 0)                                                 AS POSSUI_DUPL
		,V_EST_NF_SAI.TP_MOV
		,V_EST_NF_SAI.TP_MOV_OP_TRANSA
		,V_EST_NF_SAI.DEST_ORIG
		,CASE WHEN DEST_ORIG = 0 THEN 'CLI'
		 WHEN DEST_ORIG = 1 THEN 'FOR'
		 ELSE 'FIL'
		 END                                                                                 AS TIPO_PART
		,V_EST_NF_SAI.CD_IT                                                                  AS NUM_ITEM
		,V_EST_NF_SAI.CD_PROD                                                                AS COD_ITEM
		,EST_PROD_CPL.TP_PROD                                                                AS TIPO_ITEM
		,EST_PROD.DS_PROD
		,V_EST_NF_SAI.QT_IT
		,V_EST_NF_SAI.VLR_TOT_IT                                                             AS VLR_ITEM
		,V_EST_NF_SAI.CD_TRIB_FC                                                             AS CST_ICMS
		,V_EST_NF_SAI.TRIB_FC_ELETRONICO
		,V_EST_NF_SAI.CD_NT_OP_FC                                                            AS CFOP
		,V_EST_NF_SAI.VLR_BASE_ICMS_IT                                                       AS VLR_BASE_ICMS
		,V_EST_NF_SAI.ALIQ_ICMS                                                               ALIQ_ICMS
		,V_EST_NF_SAI.VLR_ICMS_IT                                                            VLR_ICMS_IT
		,V_EST_NF_SAI.VLR_BASE_SUBS                                                          AS VLR_BASE_SUBS
		,V_EST_NF_SAI.VLR_ICMS_SUBS						                                     AS VLR_ICMS_SUBS
		,VLR_IPI_IT                                                                          AS VLR_IPI_IT
		,V_EST_NF_SAI.PERC_IPI
		,ISNULL(V_EST_NF_SAI.CST_PIS, 0)                                                     CST_PIS
		,ISNULL(V_EST_NF_SAI.CST_COFINS, 0)                                                  CST_COFINS
		,ISNULL(V_EST_NF_SAI.VLR_BASE_PIS, 0)                                                VLR_BASE_PIS
		,ISNULL(V_EST_NF_SAI.PERC_ALIQ_PIS, 0)                                               PERC_ALIQ_PIS
		,ISNULL(V_EST_NF_SAI.VLR_PIS, 0)                                                     VLR_PIS
		,ISNULL(V_EST_NF_SAI.VLR_BASE_COFINS, 0)                                             VLR_BASE_COFINS
		,ISNULL(V_EST_NF_SAI.PERC_ALIQ_COFINS, 0)                                            PERC_ALIQ_COFINS
		,ISNULL(V_EST_NF_SAI.VLR_COFINS, 0)                                                  VLR_COFINS
		,V_EST_NF_SAI.VLR_ISSQN
		,V_EST_NF_SAI.PERC_ISSQN                                                             AS ALIQ_ISSQN
		,V_EST_NF_SAI.CD_CLI                                                                 AS COD_PART
		,1                                                                                   AS COD_IMP_ALMOX
		,V_EST_NF_SAI.LISTA_PROD
		,V_EST_NF_SAI.VLR_IT
		,SUBS_TRIB
		,SUBS_TRIB_ANT
		,V_EST_NF_SAI.CD_NT_OP
		,V_EST_NF_SAI.ICMS
		,V_EST_NF_SAI.ICMS_RD
		,FLAG_OPERADOR_LOG
		,ISNULL((SELECT
							 SUM(EST_NF_SAI_IT_EST_PROD_CPL_LOTE.QTDE_PROD)QTDE_PROD
						 FROM
							 EST_NF_SAI_IT_EST_PROD_CPL_LOTE,
							 EST_PROD_CPL_LOTE
						 WHERE
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = V_EST_NF_SAI.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF     = V_EST_NF_SAI.CD_NF AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD   = V_EST_NF_SAI.CD_PROD AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = EST_PROD_CPL_LOTE.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE   = EST_PROD_CPL_LOTE.CD_LOTE), 0) AS QTDE_PROD
		,ISNULL((SELECT TOP (1)
							 EST_PROD_CPL_LOTE.NR_LOTE
						 FROM
							 EST_NF_SAI_IT_EST_PROD_CPL_LOTE,
							 EST_PROD_CPL_LOTE
						 WHERE
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = V_EST_NF_SAI.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF     = V_EST_NF_SAI.CD_NF AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD   = V_EST_NF_SAI.CD_PROD AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = EST_PROD_CPL_LOTE.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE   = EST_PROD_CPL_LOTE.CD_LOTE
						 ORDER  BY
							EST_PROD_CPL_LOTE.CD_LOTE), 0)                                             AS NR_LOTE
		,ISNULL((SELECT TOP (1)
							 EST_PROD_CPL_LOTE.DT_VALID
						 FROM
							 EST_NF_SAI_IT_EST_PROD_CPL_LOTE,
							 EST_PROD_CPL_LOTE
						 WHERE
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = V_EST_NF_SAI.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF     = V_EST_NF_SAI.CD_NF AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD   = V_EST_NF_SAI.CD_PROD AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = EST_PROD_CPL_LOTE.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE   = EST_PROD_CPL_LOTE.CD_LOTE), 0) AS DT_VALID
		,ISNULL((SELECT TOP (1)
							 EST_PROD_CPL_LOTE.DT_FABR
						 FROM
							 EST_NF_SAI_IT_EST_PROD_CPL_LOTE,
							 EST_PROD_CPL_LOTE
						 WHERE
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = V_EST_NF_SAI.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF     = V_EST_NF_SAI.CD_NF AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD   = V_EST_NF_SAI.CD_PROD AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.Cd_Emp    = EST_PROD_CPL_LOTE.Cd_Emp AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND
							EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE   = EST_PROD_CPL_LOTE.CD_LOTE), 0) AS DT_FABR
		,EST_PROD_PRECO.VLR_TABELA
		,CASE WHEN V_EST_NF_SAI.CTR_PMC = 1 THEN 1
		 ELSE 0
		 END                                                                                 AS PROD_MEDICAM
		,( CASE WHEN DS_SIGLA_LINHA = 'S' THEN 0 -- siglas: E - etico,   S - similar, G - Generico |0- Similar; 1- Gen�rico; 2- �tico;
			 WHEN DS_SIGLA_LINHA = 'G' THEN 1
			 WHEN DS_SIGLA_LINHA = 'E' THEN 2
			 ELSE 0
			 END )                                                                             TIPO_MEDIC
		,ISNULL(V_EST_NF_SAI.NM_DEST, '')                                                    AS NOME_PART
		,V_EST_NF_SAI.ENDE                                                                   AS ENDERECO
		,V_EST_NF_SAI.BAIRRO
		,ISNULL(V_EST_NF_SAI.NUMERO, '')                                                     NUMERO
		,V_EST_NF_SAI.INSC_EST
		,V_EST_NF_SAI.UF
		,V_EST_NF_SAI.TEL
		,GLB_CID.CD_PAIS
		,ISNULL(GLB_MUNICIPIO.COD_MUNICIPIO_SINTEGRA, 0)                                     AS COD_IBGE
		,ISNULL(V_EST_NF_SAI.CEP, '')                                                        CEP
		,EST_PROD_CPL.TP_PROD
		,ISNULL((SELECT TOP (1)
							 CD_BARRA
						 FROM
							 EST_PROD_CD_BARRA
						 WHERE
							CD_EMP  = V_EST_NF_SAI.CD_EMP AND
							CD_PROD = V_EST_NF_SAI.CD_PROD
						 ORDER  BY
							CD_BARRA), '')                                                             AS COD_BARRA
		,V_EST_NF_SAI.NR_NCM                                                                 AS COD_NCM
		,V_EST_NF_SAI.VLR_DESC_IT
		,ISNULL(V_EST_NF_SAI_IMPOSTOS_PIS_COFINS.PIS_NF, 0)                                  PIS_NF
		,ISNULL(V_EST_NF_SAI_IMPOSTOS_PIS_COFINS.COFINS_NF, 0)                               COFINS_NF
		,DS_NT_OP
		,V_EST_NF_SAI.CD_MOV_OP
		,ISNULL(PDV_VD_EST_NF_SAI.CD_EMP, 0)                                                 AS NOTA_CUPOM
		,V_EST_NF_SAI.CD_EMP
		,V_EST_NF_SAI.FLAG_NAO_GERAR_ARQ_SPED
		,V_EST_NF_SAI.VLR_OUTROS_DESPESAS_CAB                                                AS VLR_OUTRAS_DESP_CAB
		,ISNULL(V_EST_NF_SAI.CD_PED, 0)                                                      AS COD_PED
		,ISNULL(EST_NF_SAI_CANCEL.CANCEL_FORA_PRAZO, 0)                                      CANCEL_FORA_PRAZO
		,ISNULL(EST_NF_SAI_NFE_CANCEL.NR_PROTOCOLO, '')                                      AS PROTOCOLO_CANCEL
		--,ISNULL(EST_NF_SAI_DENEGADA.CD_EMP, 0)                                               AS NOTA_DENEGADA
		,CASE WHEN  V_EST_NF_SAI.STS_NF = 3  OR ISNULL(EST_NF_SAI_DENEGADA.CD_EMP, 0) = 1 THEN 1 ELSE 0 END AS NOTA_DENEGADA
		,ISNULL(EST_NF_SAI_DAR_IT.CD_EMP, 0)                                                 AS DIFAL
		,ISNULL(EST_NF_SAI_DAR_IT.VLR_BASE_ICMS, 0)                                          VLR_BASE_ICMS_DIFAL
		,ISNULL(EST_NF_SAI_DAR_IT.PERC_ICMS_DESTINO, 0)                                      ALIQ_ICMS_DIFAL
		,ISNULL(EST_NF_SAI_DAR_IT.VLR_ICMS, 0)                                               VLR_ICMS_DIFAL
		,ISNULL((SELECT
							 VLR_DAR_RECOLHER
						 FROM
							 EST_NF_SAI_DAR
						 WHERE
							V_EST_NF_SAI.CD_EMP       = EST_NF_SAI_DAR.CD_EMP AND
							V_EST_NF_SAI.CD_FILIAL    = EST_NF_SAI_DAR.CD_FILIAL AND
							V_EST_NF_SAI.CD_NF        = EST_NF_SAI_DAR.CD_NF AND
							EST_NF_SAI_DAR.UF_DESTINO = 1), 0)                                         AS VLR_DAR_DEST
		,ISNULL(VLR_DAR_RECOLHER, 0)                                                         AS VLR_DAR_ORIG
		,CONTRIBUINTE
		,ISNULL(V_EST_NF_SAI.VLR_FECOP, 0)                                                                AS VLR_FECOP
		,ISNULL(V_EST_NF_SAI.NR_CEST,0)											AS NR_CEST
		,V_EST_NF_SAI.COD_IBGE_MUNICIPIO_DESTINATARIO
		,V_EST_NF_SAI.END_DESTINATARIO
		,V_EST_NF_SAI.BAIRRO_DESTINATARIO
		,V_EST_NF_SAI.CEP_DESTINATARIO
		,V_EST_NF_SAI.CIDADE_DESTINATARIO
		,V_EST_NF_SAI.CNPJ_DESTINATARIO
		,V_EST_NF_SAI.INSC_ESTADUAL_DESTINATARIO
		,V_EST_NF_SAI.RZ_DESTINATARIO
		,V_EST_NF_SAI.UF_DESTINATARIO
		,V_EST_NF_SAI.CD_CID_DESTINATARIO
        ,ISNULL(EST_NF_SAI_EST_NF_NFE_INU.CD_EMP,0) INUTILIZADO
  														
	FROM
		V_EST_NF_SAI
		INNER JOIN EST_PROD_CPL ON
			V_EST_NF_SAI.CD_EMP = EST_PROD_CPL.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
			V_EST_NF_SAI.CD_PROD = EST_PROD_CPL.CD_PROD
		INNER JOIN EST_PROD ON
			EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP AND
			EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD

		INNER JOIN V_APURA_ICMS ON
			V_EST_NF_SAI.CD_EMP		= V_APURA_ICMS.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL	= V_APURA_ICMS.CD_FILIAL AND
			V_EST_NF_SAI.CD_NF		= V_APURA_ICMS.CD_NF AND
			V_EST_NF_SAI.DT_EMI_NF	= V_APURA_ICMS.DT_ENT_SAI AND
			V_APURA_ICMS.TIPO = 1

		LEFT JOIN EST_NF_SAI_NF_ENT ON
			EST_NF_SAI_NF_ENT.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			EST_NF_SAI_NF_ENT.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			EST_NF_SAI_NF_ENT.CD_NF_SAI = V_EST_NF_SAI.CD_NF
		LEFT JOIN EST_PROD_PRECO ON
			EST_PROD_PRECO.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			EST_PROD_PRECO.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			EST_PROD_PRECO.CD_PROD = V_EST_NF_SAI.CD_PROD
		LEFT JOIN RC_DEB_EST_NF_SAI ON
			RC_DEB_EST_NF_SAI.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			RC_DEB_EST_NF_SAI.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			RC_DEB_EST_NF_SAI.CD_NF = V_EST_NF_SAI.CD_NF
		LEFT JOIN GLB_CID ON
			V_EST_NF_SAI.CD_CID = GLB_CID.CD_CID
		LEFT JOIN GLB_CID_GLB_MUNICIPIO ON
			GLB_CID_GLB_MUNICIPIO.CD_CID = GLB_CID.CD_CID
		LEFT JOIN GLB_MUNICIPIO ON
			GLB_MUNICIPIO.CD_MUNICIPIO = GLB_CID_GLB_MUNICIPIO.CD_MUNICIPIO
		LEFT JOIN V_EST_NF_SAI_IMPOSTOS_PIS_COFINS ON
			V_EST_NF_SAI_IMPOSTOS_PIS_COFINS.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			V_EST_NF_SAI_IMPOSTOS_PIS_COFINS.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			V_EST_NF_SAI_IMPOSTOS_PIS_COFINS.CD_NF = V_EST_NF_SAI.CD_NF
		LEFT JOIN EST_NF_SAI_NFE ON
			EST_NF_SAI_NFE.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			EST_NF_SAI_NFE.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			EST_NF_SAI_NFE.CD_NF = V_EST_NF_SAI.CD_NF
		LEFT JOIN PDV_VD_EST_NF_SAI ON
			V_EST_NF_SAI.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND
			V_EST_NF_SAI.CD_NF = PDV_VD_EST_NF_SAI.CD_NF
		LEFT JOIN EST_NF_SAI_CANCEL ON
			EST_NF_SAI_CANCEL.CD_EMP = V_EST_NF_SAI.CD_EMP AND
			EST_NF_SAI_CANCEL.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL AND
			EST_NF_SAI_CANCEL.CD_NF = V_EST_NF_SAI.CD_NF
		LEFT JOIN EST_NF_SAI_NFE_CANCEL ON
			EST_NF_SAI_CANCEL.CD_EMP = EST_NF_SAI_NFE_CANCEL.CD_EMP AND
			EST_NF_SAI_CANCEL.CD_FILIAL = EST_NF_SAI_NFE_CANCEL.CD_FILIAL AND
			EST_NF_SAI_CANCEL.CD_NF = EST_NF_SAI_NFE_CANCEL.CD_NF
		LEFT JOIN EST_NF_SAI_DENEGADA ON
			V_EST_NF_SAI.CD_EMP = EST_NF_SAI_DENEGADA.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL = EST_NF_SAI_DENEGADA.CD_FILIAL AND
			V_EST_NF_SAI.CD_NF = EST_NF_SAI_DENEGADA.CD_NF
		LEFT JOIN EST_NF_SAI_DAR ON
			V_EST_NF_SAI.CD_EMP = EST_NF_SAI_DAR.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL = EST_NF_SAI_DAR.CD_FILIAL AND
			V_EST_NF_SAI.CD_NF = EST_NF_SAI_DAR.CD_NF AND
			EST_NF_SAI_DAR.UF_DESTINO = 0
		LEFT JOIN EST_NF_SAI_DAR_IT ON
			EST_NF_SAI_DAR.CD_EMP	 = EST_NF_SAI_DAR_IT.CD_EMP AND
			EST_NF_SAI_DAR.CD_FILIAL = EST_NF_SAI_DAR_IT.CD_FILIAL AND
			EST_NF_SAI_DAR.CD_NF	= EST_NF_SAI_DAR_IT.CD_NF AND
			EST_NF_SAI_DAR.CD_DAR	= EST_NF_SAI_DAR_IT.CD_DAR  
			AND	EST_PROD.CD_PROD	= EST_NF_SAI_DAR_IT.CD_PROD

       LEFT JOIN EST_NF_SAI_EST_NF_NFE_INU ON
	   		V_EST_NF_SAI.CD_EMP	 = EST_NF_SAI_EST_NF_NFE_INU.CD_EMP AND
			V_EST_NF_SAI.CD_FILIAL = EST_NF_SAI_EST_NF_NFE_INU.CD_FILIAL AND
			V_EST_NF_SAI.CD_NF	= EST_NF_SAI_EST_NF_NFE_INU.CD_NF  

		OUTER APPLY (SELECT SUM(CASE WHEN RIGHT( NF_SAI2.CD_TRIB_FC, 2) NOT IN ( '10','30','70') THEN NF_SAI2.VLR_BASE_ICMS_IT ELSE 0 END) AS VLR_BASE_ICMS_PROD,
							SUM(CASE WHEN RIGHT( NF_SAI2.CD_TRIB_FC, 2) NOT IN ( '10','30','70') THEN NF_SAI2.VLR_ICMS_IT ELSE 0 END) AS VLR_ICMS_PROD,
							SUM(CASE WHEN RIGHT( NF_SAI2.CD_TRIB_FC, 2) NOT IN ( '10','30','70') THEN NF_SAI2.VLR_BASE_SUBS ELSE 0 END) AS VLR_BASE_SUBS_PROD,
							SUM(CASE WHEN RIGHT( NF_SAI2.CD_TRIB_FC, 2) NOT IN ( '10','30','70') THEN NF_SAI2.VLR_ICMS_SUBS ELSE 0 END) AS VLR_ICMS_SUBS_PROD
					 FROM DBO.V_EST_NF_SAI NF_SAI2 
					 WHERE V_EST_NF_SAI.CD_EMP = NF_SAI2.CD_EMP
					 AND V_EST_NF_SAI.CD_FILIAL = NF_SAI2.CD_FILIAL
					 AND V_EST_NF_SAI.CD_NF = NF_SAI2.CD_NF
					 AND V_EST_NF_SAI.DT_EMI_NF = NF_SAI2.DT_EMI_NF
					 AND EXISTS (SELECT 1 FROM DBO.V_EST_NF_SAI NF_SAI3
								 WHERE V_EST_NF_SAI.CD_EMP = NF_SAI3.CD_EMP
								 AND V_EST_NF_SAI.CD_FILIAL = NF_SAI3.CD_FILIAL
								 AND V_EST_NF_SAI.CD_NF = NF_SAI3.CD_NF
								 AND V_EST_NF_SAI.DT_EMI_NF = NF_SAI3.DT_EMI_NF
								 AND RIGHT( NF_SAI3.CD_TRIB_FC, 2) IN ( '10','30','70')
								 AND NF_SAI3.TP_MOV = 11
								 AND ISNULL((SELECT VALOR 
											 FROM PRC_FILIAL_CONFIG PRC
											 WHERE CD_CHAVE = 'ZERAR_ICMS_NORMAL_ST_DEV_COMPRAS_SPED_FISCAL'
											 AND PRC.CD_FILIAL = V_EST_NF_SAI.CD_FILIAL),0) = 1
								 
								 )
					) CAb


